%{
This m-file belongs to the article 'The role of the electrolyte identity on
electrochemical CO2 conversion in the absence of mass transfer limitations'
Authors: Anne Sustronk (1,2) , Nieck E. Benes (1) , Guido Mul (2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to prepare Figure 2.

Version date m-file: Feb 22, 2023
%}

clear all, clc, close all

% Some constants
pH = linspace(2,8,1000);        % pH
F = 96485;                      % (C/mol)
V = 50/1000;                    % Catholyte volume (L)
t = 3600;                       % Duration of experiment (s)
size = 6;                       % Graph size
A = 0.5;                        % Fiber area (cm^2)

% Calculate proton concentration
H = 10.^-pH;                    % (mol/L)
HAbs = H.*V;                    % (mol)

% Calculate amount of charge related to converting 2 H+ into H2
QH = (HAbs.*F)/2;               % (C)

% Corresponding current density with t = 1 hr
IH2 = -(QH./t)*1000/A;          % (mA)

% Plot results
fig = figure(1);

plot(pH,IH2,'-k')

% X and Y labels
xlabel('pH')
ylabel('Max. I_{H_{2}} from H^{+} (mA cm^{2})')

% Figure properties
fig.Units = 'centimeters';
fig.Color = 'white';
fig.Position = [10 10 size*(4/3) size];


% Additional axes properties
ax = gca;
ax.FontName = 'Times New Roman';
ax.TickDir = 'in';
ax.FontSize = 10;
ax.LineWidth = 1;
axis([2 8 -2 0])
ax.XTick = linspace(2,8,7);
ax.YTick = linspace(-2,0,5);
ytickformat('%.1f')
box on